/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.wizard;

import com.quantumdata.sct.dao.vo.AbstractStepVO;
import com.quantumdata.sct.dao.vo.CompositeStepVO;
import com.quantumdata.sct.dao.vo.TestVO;
import com.quantumdata.sct.engine.test.TestEngine;
import com.quantumdata.sct.engine.test.TestEngineContext;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;

public class TestStepsPage {
    private TestEngine testEngine;
    private Vector testSteps;
    private CompositeStepVO setupStepVO;
    private boolean hasExecuted;
    private boolean userFound = false;
    private JPanel displayPanel;

    TestStepsPage(TestEngine testEngine) throws Exception {
        this.testEngine = testEngine;
        this.testSteps = new Vector();
    }

    void addStep(AbstractStepVO abstractStepVO) {
        this.testSteps.add(abstractStepVO);
    }

    void addSetupStep(CompositeStepVO compositeStepVO) {
        this.setupStepVO = compositeStepVO;
    }

    boolean hasExecuted() {
        return this.hasExecuted;
    }

    void setExecuted(boolean bl) {
        this.hasExecuted = bl;
    }

    public boolean executePage() {
        if (!this.hasExecuted) {
            Iterator iterator = null;
            iterator = this.setupStepVO != null ? this.setupStepVO.getChildStepsList().iterator() : this.testSteps.iterator();
            TestEngineContext testEngineContext = this.testEngine.getContext();
            while (iterator.hasNext()) {
                AbstractStepVO abstractStepVO = (AbstractStepVO)iterator.next();
                try {
                    if (testEngineContext.executeStep(abstractStepVO)) continue;
                    return false;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.hasExecuted = true;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    public JPanel getDisplayPanel() {
        TestVO testVO = this.testEngine.getTest();
        this.displayPanel = new JPanel(new BorderLayout());
        this.displayPanel.setBackground(Color.white);
        this.displayPanel.add((Component)SCTSelection.getTestHeader(testVO), "First");
        this.displayPanel.add((Component)this.getCenterPanel(), "Center");
        return this.displayPanel;
    }

    private JPanel getCenterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        Iterator iterator = null;
        iterator = this.setupStepVO != null ? this.setupStepVO.getChildStepsList().iterator() : this.testSteps.iterator();
        int n = 0;
        TestEngineContext testEngineContext = this.testEngine.getContext();
        while (iterator.hasNext()) {
            AbstractStepVO abstractStepVO = (AbstractStepVO)iterator.next();
            JPanel jPanel2 = testEngineContext.getStepDisplay(abstractStepVO, n++);
            this.userFound = this.userFound || testEngineContext.isUserStep();
            jPanel.add((Component)jPanel2, gridBagConstraints);
        }
        return jPanel;
    }

    public boolean isUserFound() {
        boolean bl = this.userFound;
        this.userFound = false;
        return bl;
    }
}

